function [fp_matrix, fn_matrix, opt_thrsh] = perf_measure()
%-------------------------------------------------------------------------
% Desc - Caluclates a performance matrix. Each column of the matrix is the
%        performance of the system for one particular threshold value.
%
%        Definitions:
%        1) False Positives - When desired is 0, and observed is 1
%        2) False Negatives - When desired is 1, and observed is 0.
%
%        (c), 2005, Prashant Joshi (joshi@igi.tugraz.at)
%-------------------------------------------------------------------------
global THRSH_VAL DT TSTIM NO_VALIDATE KERNEL_SIZE NO_FB_CHANNELS
global RESULT_PATH
NVALIDATE = 50;
%THRSH_VAL=(0:1:10); DT=0.01; TSTIM=1; NVALIDATE=30; KERNEL_SIZE=30e-3; NO_FB_CHANNELS=8;

TOTAL_POINTS = length(0:DT:TSTIM);
fp_matrix = zeros(NVALIDATE, length(THRSH_VAL));
fn_matrix = zeros(NVALIDATE, length(THRSH_VAL));
for i = 1:NVALIDATE
    [fname, err] = sprintf('%s/run%g.mat', RESULT_PATH, i);
    load(fname); % loads the params from this validation run

    % find the desired value
    des_val = S.info(1).data;
    des_val(des_val ~=0) = 1;

    % create the spike trains from the response of spiking readouts
    Stim = R{4};
    % calculate the mean firing rate
    mfr = lpf(sumofrates(Stim, KERNEL_SIZE, DT, TSTIM), KERNEL_SIZE/DT)./NO_FB_CHANNELS;
    for j = 1:length(THRSH_VAL)
        % calculate the observed value for this threshold
        obs_val = mfr;
        obs_val(obs_val <THRSH_VAL(j)) = 0;
        obs_val(obs_val ~=0) = 1;
        fp = find(des_val == 0 & obs_val == 1);
        fp(isempty(fp)) = 0;
        fn = find(des_val == 1 & obs_val == 0);
        fn(isempty(fn)) = 0;
        fp = length(fp)/TOTAL_POINTS;
        fn = length(fn)/TOTAL_POINTS;
        fp_matrix(i,j) = fp;
        fn_matrix(i,j) = fn;
    end
end;

mean_fp = mean(fp_matrix);
mean_fn = mean(fn_matrix);

% now calculate the optimum threshold (the threshold for which the sum of 
% false positive and false negative is minimum)

sum_err = mean_fp + mean_fn;
idx = find(sum_err == min(sum_err));
opt_thrsh = THRSH_VAL(idx);;

plot(mean_fp, mean_fn, 'k-', 'linewidth', 2 );%, mean_fp, mean_fn, 'ro', 'linewidth', 2); 
hold on;
plot(mean_fp(idx), mean_fn(idx), 'rO','linewidth', 2  );

xlabel('False Positives');
ylabel('False Negatives');
[ttl, err] = sprintf('Total Validation Runs = %g, Optimum Threshold = %g Hz', NVALIDATE, opt_thrsh);
title(ttl, 'fontsize', 14, 'fontweight', 'bold');
