%--------------------------------------------------------------------------
% Desc - Creates the liquid for the simulation
%
% Also See - load_params.m
%
%            (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%--------------------------------------------------------------------------
% create the input neurons
% Create an input pool of  spiking input neurons.
[nmc, pin_r1] = add(nmc, 'Pool', 'origin', ORIG_POOL_IP_R1, 'size', ...
                           [1 2 4], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);

[nmc, pin_r2] = add(nmc, 'Pool', 'origin', ORIG_POOL_IP_R2, 'size', ...
                           [1 2 4], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);

[nmc, pin_r3] = add(nmc, 'Pool', 'origin', ORIG_POOL_IP_R3, 'size', ...
                           [1 2 4], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);

[nmc, pin_r4] = add(nmc, 'Pool', 'origin', ORIG_POOL_IP_R4, 'size', ...
                           [1 2 4], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);

% create the pool of teacher feedback neurons
[nmc, pfb] = add(nmc, 'Pool', 'origin', ORIG_POOL_FB, 'size', ...
                           [1 2 NO_READOUTS/2], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);
                 
% Create the liquid
[nmc, poolnmc] = add(nmc, 'Pool', 'origin', ORIG_POOL_NMC, 'size', CIRCUIT_SIZE, ...
                    'frac_EXC', 0.8, ...
		    'type', 'LifNeuron', 'Neuron.Vthresh', VTHRESH, ...
                     'Neuron.Vreset', VRESET, 'Neuron.Vinit', VINIT, ...
                     'Neuron.Iinject', IINJECT, 'Neuron.Trefract', TREFRACT, ...
                     'Neuron.Inoise', INOISE);

% Connect the  input neurons to the liquid
% The first two neurons simulate the start and stop burst
[nmc, cip_r1] = add(nmc, 'Conn', 'src', pin_r1, 'dest', [6 0 4; 10 4 8], ...
                             'type', STYPE_IP, 'Cscale', csip2liq, ...
                             'Wscale', wsip2liq, 'rescale', 0, 'lambda', lamip2liq);

[nmc, cfb] = add(nmc, 'Conn', 'src', pfb, 'dest', [6 0 9; 10 4 13], ...
                             'type', STYPE_IP, 'Cscale', csip2liq, ...
                             'Wscale', wsip2liq, 'rescale', 0, 'lambda', lamip2liq);

[nmc, cip_r2] = add(nmc, 'Conn', 'src', pin_r2, 'dest', [6 0 14; 10 4 18], ...
                             'type', STYPE_IP, 'Cscale', csip2liq, ...
                             'Wscale', wsip2liq, 'rescale', 0, 'lambda', lamip2liq);

[nmc, cip_r3] = add(nmc, 'Conn', 'src', pin_r3, 'dest', [6 0 19; 10 4 23], ...
                             'type', STYPE_IP, 'Cscale', csip2liq, ...
                             'Wscale', wsip2liq, 'rescale', 0, 'lambda', lamip2liq);

[nmc, cip_r4] = add(nmc, 'Conn', 'src', pin_r4, 'dest', [6 0 24; 10 4 27], ...
                             'type', STYPE_IP, 'Cscale', csfb, ...
                             'Wscale', wsfb, 'rescale', 0, 'lambda', lamfb, ...
                             'Synapse.tau',0.003, 'Synapse.delay',0);
         
                    

% make recurrent connections in the liquid
[nmc, cr] = add(nmc, 'Conn', 'dest', poolnmc, 'src', poolnmc,...
                         'Cscale', csliq, 'Wscale', wsliq, 'lambda', lamliq,...
		                 'type', STYPE_CIRCUIT);

% now add a pool of linear neurons which we will train using linear
% regression
[nmc, plin] = add(nmc, 'Pool', 'origin', ORIG_POOL_LINEAR_READOUTS, ...
                            'size', [1 1 NO_READOUTS], ...
                            'type', 'LinearNeuron', 'frac_EXC',1);
		   
% connect the linear neuron with the liquid
[nmc, clin] = add(nmc, 'Conn', 'src', poolnmc, 'dest', plin, 'lambda', Inf, ...
                            'Cscale', csreadout, 'type', 'StaticSpikingSynapse', 'Wscale', wsreadout,...
                  'C', [0.95 0.95 0.95 0.95]);
%[nmc, clin] = add(nmc, 'Conn', 'src', [6 0 4; 10 4 23], 'dest', plin, 'lambda', lamreadout, ...
%                            'Cscale', csreadout, 'type', 'StaticSpikingSynapse', 'Wscale', wsreadout);

conn = get(nmc, 'conn');
conn = conn(clin);
csim('set', conn.synapseIdx, 'tau', TAU_LINEAR_NEURON);

% now add recorders
nmc = record(nmc, 'Pool', poolnmc, 'Field', 'spikes','dt', DT);
nmc = record(nmc, 'Pool', poolnmc, 'Field', 'Vm','dt', DT);
nmc = record(nmc, 'Pool', plin, 'Field', 'Vm','dt', DT);
