function op = lpf(ip, kernelsize)
%-------------------------------------------------------------------------
% Desc - This function performs a low pass filter of the ip value,
%        using a gaussian kernel with the kernel length of kernelsize.
%        Basically it is just a weighted sum operation. At time point t,
%        the peak of the gaussian kernel is at ip(t).
%
%        (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%-------------------------------------------------------------------------

len = length(ip);
for i = 1:len
    if(i<=kernelsize)
        nval = i;
    else
        nval = kernelsize;
    end;
    op(i) = gauss_kernel(ip(i-nval+1:i));
end;

function val = gauss_kernel(ip)
len = length(ip);
ker = linspace(0,1,len);
ker = (1/(2*pi))*(exp((ker.*ker)/(2)));
ker = ker./(max(ker));
val = sum(ker.*ip)/sum(ker);
