%--------------------------------------------------------------------------
% Desc - This file defines the parameters for the simulation
%
%            (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%--------------------------------------------------------------------------
global LORATE HIRATE BURSTDUR RLO RHI NO_FB_CHANNELS RATE_READOUT RATE_NOISE NO_IP_CHANNELS NO_READOUTS TSTIM BASE_RATE DT KERNEL_SIZE THRSH_VAL NVALIDATE CHANNELS_PER_RATE
global RESULT_PATH
%--------------------------------------------------------------------------
% Simulation Parameters
%--------------------------------------------------------------------------
REGEN_CIRCUIT = 0;
% the time step of simulation in seconds
DT = 5e-3;

% the total time of simulation in seconds
TSTIM = 1;

% the higher the value the more the plots that will be generated
PLOTTING_LEVEL = 0;

% number of training iterations
NTRAIN = 200;

% number of validation runs
NVALIDATE = 50;

% The scaling factor for the tranfer of linear readouts weights to spiking
% readout
ALPHA = 1.333e-10;

% The size of kernel window for the open loop readouts
KERNEL_SIZE = 30e-3;

% The values for threshold that are used to evaluate performance.
THRSH_VAL = (0:0.5:60);

CHANNELS_PER_RATE = 8;

LORATE = 5;
HIRATE = 120;
BURSTDUR = 50e-3;
BASE_RATE = 0;
RATE_READOUT = 40;
RATE_NOISE = 10;


%--------------------------------------------------------------------------
% Liquid parameters
%--------------------------------------------------------------------------

SET_STATIC_SYNAPSES = 0;

CIRCUIT_PATH   = './data/circuit';
if(SET_STATIC_SYNAPSES == 1)
    RESULT_PATH = './results_static';
else
    RESULT_PATH = './results_dynamic';
end

% circuit type
nmc = neural_microcircuit;

% neuron type
NTYPE_CIRCUIT = 'LifNeuron';
NTYPE_IP = 'SpikingInputNeuron';

% synapse types
STYPE_IP = 'StaticSpikingSynapse';
STYPE_CIRCUIT ='DynamicSpikingSynapse';

% circuit size
CIRCUIT_SIZE = [5 5 24];

% number of input channels (excluding feedback)
NO_IP_CHANNELS = 32;

% number of readouts
NO_READOUTS = 8;
NO_FB_CHANNELS = NO_READOUTS;

% define the origin of input pool, liquid and the linear readout
ORIG_POOL_NMC = [6 0 4];
ORIG_POOL_IP_R1  = [1 1 4];
ORIG_POOL_FB  = [1 1 9];
ORIG_POOL_IP_R2  = [1 1 14];
ORIG_POOL_IP_R3  = [1 1 19];
ORIG_POOL_IP_R4  = [1 1 24];
ORIG_POOL_LINEAR_READOUTS = [12 0 9];
ORIG_POOL_SPIKING_READOUTS = [13 0 9];

% define the time constant of the linear readout in seconds
TAU_LINEAR_NEURON = 30e-3;

% set the connection parameters

% for connections from ip --> liq
wsip2liq  = 0.5;
csip2liq  = 10;
lamip2liq = 5;
%wsip2liq  = 0.1;
%csip2liq  = 10;
%lamip2liq = 5;

% for connection that simulate teacher feedback
wsfb   = 0.4;
csfb = 10;
lamfb  = 5.0;
%wsfb   = 0.035;
%csfb = 20;
%lamfb  = 6.0;

% for recurrent connections liq --> liq
wsliq  = 2;
csliq  = 1;
lamliq = 3;

% for connections from liq --> linear readouts
wsreadout =1e8;
csreadout = 1;
lamreadout =Inf;

% for connections from liq --> spiking readouts
ws_spk_readout = 1;

% spiking readout params
VTHRESH = 0.015;
VRESET = [0 0];
VINIT  = [0 0];
IINJECT = [13.5e-9 14.5e-9];
TREFRACT = 0.003;
INOISE = [4e-9 5e-9];
CM     = 3e-8;

