%--------------------------------------------------------------------------
% Desc - Increments the weight of the spiking readout
%
% To run in the open loop, turn ON the teacher feedback and turn OFF the
% feedback from spiking readouts
%--------------------------------------------------------------------------
BETA = 5;
pool = get(nmc, 'pool');
pool = pool(8);
spiking_readout_idx = pool.neuronIdx;

% connect the neurons from the liquid to the spiking readouts

for i = 1:NO_READOUTS
    [pre_syn, post_syn] = csim('get', spiking_readout_idx(i), 'connections');
    for j = 1:length(pre_syn)
        Wsr.readout(i).weights(j) = (Wsr.readout(i).weights(j))*BETA;
        csim('set', pre_syn(j), 'W', Wsr.readout(i).weights(j));
    end
end
reset(nmc);
