function [y, r1, r2] = att_swtch_op(S)

%-------------------------------------------------------------------------
% This readout performs the attention switching, i.e. if the target value
% of the closed loop spiking readout is in LOW state then this readout 
% computes the sum of rates of channels 1&2 in the last 100 msec, otherwise
% it computes the sum of rates of channels 15&16 in the last 100 msec.
%
%    (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%-------------------------------------------------------------------------
global KERNEL_SIZE NO_IP_CHANNELS 

dt = S.info(1).dt;
Tstim = S.info(1).Tstim;
t = (0:dt:Tstim);

y = zeros(size(t));
len = length(t);


% create the stimulus
S1 = S;
S2 = S;
S1.channel(3:end) = [];
S2.channel(1:14) = [];
S2.channel(3:end) = [];
%S1.channel((NO_IP_CHANNELS/2)+1:end) = [];
%S2.channel(1:NO_IP_CHANNELS/2) = [];
%S2.channel(NO_IP_CHANNELS/2+1:end) = [];

r1 = sumofrates(S1, KERNEL_SIZE, dt, Tstim);
r1 = lpf(r1, KERNEL_SIZE/dt);
r1 = r1./max(r1);

r2 = sumofrates(S2, KERNEL_SIZE, dt, Tstim);
r2 = lpf(r2, KERNEL_SIZE/dt);
r2 = r2./max(r2);

for i = 1:len
    if(S.info(1).data(i) == 0)                   % val = 00
        y(i) = r1(i);
    else                                               % val = 11
        y(i) = r2(i);
    end;
end;
idx = find(isnan(y));
y(idx) = 0;
