  %-----------------------------------------------------------------------
  % Desc - Makes a plot for the performance of the discrete attractor
  %        for the case with dynamic synapses and with static synapses
  %
  %        (c), 2006, Prashant Joshi (joshi@igi.tugraz.at)
  %-----------------------------------------------------------------------
  clear all classes;
  close all;
  
  load_params;

  perf_dyn = [];
  perf_sta = [];
  RESULT_PATH1 = './results_dynamic';
  RESULT_PATH2 = './results_static';
  for i = 1:NVALIDATE
      [fn, e] = sprintf('%s/run%g.mat', RESULT_PATH1, i);
      load(fn);
      perf_dyn(i,:) = performance_of_spiking_readouts(S,R);
      
      [fn, e] = sprintf('%s/run%g.mat', RESULT_PATH2, i);
      load(fn);
      perf_sta(i,:) = performance_of_spiking_readouts(S,R);
  end

  subplot(211)
  mean_dyn = mean(perf_dyn);
  std_dyn  = std(perf_dyn);
  bar(mean_dyn(1:8));
  hold on;
  bar(9,mean_dyn(:,9), 'r');
  legend('individual spiking readout performance', 'average performance', 2);
  hold on;
  x = (1:9);
  y = mean_dyn;
  e = std_dyn;
  h = errorbar(x,y,e,'g');
  set(h(2), 'visible', 'off');
  xlabel('Readout #');
  ylabel('Performance');
  title('Performance of spiking readouts with dynamic synapses');
  
  subplot(212)
  mean_sta = mean(perf_sta);
  std_sta  = std(perf_sta);
  bar(mean_sta(1:8));
  hold on;
  bar(9,mean_sta(:,9), 'r');
  legend('individual spiking readout performance', 'average performance', 2);
  hold on;
  x = (1:9);
  y = mean_sta;
  e = std_sta;
  h = errorbar(x,y,e,'g');
  set(h(2), 'visible', 'off');
  xlabel('Readout #');
  ylabel('Performance');
  title('Performance of spiking readouts with static synapses');
