%-------------------------------------------------------------------------
% This script adds two linear readouts to our setup. These linear readouts
% work in the open loop mode and have the target functions as follows:
%
%      (a) Readout 1 - Computes the sum of rate of channel 1-8 when the 
%          collective output of closed loop readouts is in LOW state,
%          and computes the sum of rate of channels 9-16 when the 
%          collective output of the closed loop readouts is in HIGH state.
%
%      (b) Readout 2 - Computes the product of rate of channels 1-16.
%
%      (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%-------------------------------------------------------------------------
NO_TRAIN = NTRAIN;
NO_TEST  = NTRAIN;
T.train_stimuli = train_stimuli(1:NO_TRAIN);
T.train_response = train_response(1:NO_TRAIN);
V.test_stimuli = train_stimuli(1:NO_TRAIN);
V.test_response = train_response(1:NO_TRAIN);
%V.test_stimuli = train_stimuli(NO_TRAIN+1:end);
%V.test_response = train_response(NO_TRAIN+1:end);

%------------------------------------------------------------------
% Calculating liquid states for training
ltrain_val  = response2states(T.train_response,[], ...
                             [0:DT:TSTIM]);%, ...
                             %{ 'spikes2alpha' 0.05 });
ltest_val  = response2states(V.test_response,[], ...
                             [0:DT:TSTIM]);%, ...
                             %{ 'spikes2alpha' 0.05 });


%train_states(i) = response2states(T.train_response(i),[],[0:DT:TSTIM]);

% Create readouts
%readout{1} = external_readout('description', sprintf('Attention Switching'),...
%                              'targetFunction', attention_switching_readout,...
%                              'algorithm', pdelta('n',51,'rho',20,'maxepoch',150,'valid_wopt',1,'valFrac',0.2));

% readouts for testing
clear readout;
readout{1} = external_readout('targetFunction',roch1,...
                      'description','rate of channel 17-24', ...
                      'algorithm', linear_regression);
readout{2} = external_readout('targetFunction',roch2,...
                      'description','rate of channel 25-32',...
                      'algorithm', linear_regression);
readout{3} = external_readout('targetFunction',rofb,...
                      'description','rate of feedback channels',...
                      'algorithm', linear_regression);
readout{4} = external_readout('targetFunction',roprod,...
                      'description','Computes Product',...
                      'algorithm', linear_regression);
readout{5} = external_readout('targetFunction',roampl,...
                      'description','Amplification',...
                      'algorithm', linear_regression);
readout{6} = external_readout('targetFunction',roattn,...
                      'description','Attention Switching',...
                      'algorithm', linear_regression);

[trained_readouts] = train_readouts(readout,ltrain_val,T.train_stimuli,...
                                                        ltest_val, V.test_stimuli);


