function plot(this,input)
global NO_IP_CHANNELS NO_FB_CHANNELS RATE_READOUT RATE_NOISE DT TSTIM

time = (0:DT:TSTIM);

subplot(2,1,1);
TOT_IP = NO_IP_CHANNELS + NO_FB_CHANNELS;
for i = 1:TOT_IP
    st = input.channel(i).data;
    if(i<=16)
        col = 'k';
    elseif(i>16 && i<=24)
        col = 'r';
    elseif(i>24 && i<=32)
        col = 'b';
    else
        col = 'k';
    end
    line([st;st],(TOT_IP-i)+[0.3; -0.3]*ones(1,length(st)),'Color',col,'Linewidth',1.5);
    axis([0 input.info(1).Tstim (-2) (TOT_IP+1)]);
end;
xlabel('Input Channels (Red), Feedback Channels (Black)');
title('Inputs to the circuit', 'fontsize', 14, 'fontweight', 'bold');
subplot(2,1,2);
plot(input.info(1).data, 'k', 'linewidth',2);
axis([0 (length(time)-1) 0 4]);
xlabel('Target Firing Rate for Spiking Readout(s)');
