function I=generate(gi, varargin)
%-------------------------------------------------------------------------
% Desc - This file generates the 3 input channels for the stimulus.
%        The first two channels are poisson spike trains with time
%        varying rate. The third channel is the channel which
%        simulates the feedback from a discrete attractor.
%
%        (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------
global LORATE HIRATE BURSTDUR RLO RHI NO_FB_CHANNELS RATE_READOUT RATE_NOISE NO_IP_CHANNELS BASE_RATE DT TSTIM
% LOVAL = 0;
% HIVAL  = 40;
% RLO     = 0.1;
% RHI      = 0.95;
% NO_FB_CHANNELS = 8;
% RATE_READOUT = 40;
% RATE_NOISE = 10;
% NO_IP_CHANNELS = 2;
dt = DT;
Tstim = TSTIM;

t=0:dt:Tstim;
lent = length(t);

%-------------------------------------------------------------------------
no_switches = randperm(3);
no_switches = no_switches(1) +2; % will give either 3,4,5 switches
time_switch = TSTIM* sort(rand(1,no_switches));
flag = 0;
time_lo = [];
time_hi = [];

rate_lo = LORATE*ones(size(t));
bg_lo = rate2spikes(rate_lo, DT, NO_IP_CHANNELS/2, TSTIM);
rate_hi = HIRATE*ones(size(0:DT:BURSTDUR));

target_fn = [];
for i = 1:NO_IP_CHANNELS/4
    r1.channel(i).data = [];
    r2.channel(i).data = [];
end
for i = 1:length(time_switch)
    time_switch_idx = find(t<=time_switch(i));
    time_switch_idx = time_switch_idx(end);
    time_switch(i) = t(time_switch_idx);
    if(flag == 0)
        target_fn = [target_fn zeros( 1, (find(t == time_switch(i)) -length(target_fn) )) ];
        bg = rate2spikes(rate_hi, DT, NO_IP_CHANNELS/4, BURSTDUR);
        for j = 1:NO_IP_CHANNELS/4
            r1.channel(j).data = [r1.channel(j).data (bg{j}+time_switch(i))];
        end
        flag = 1;
    else
        target_fn = [target_fn ones(1, (find(t == time_switch(i)) -length(target_fn)))];
        bg = rate2spikes(rate_hi, DT, NO_IP_CHANNELS/4, BURSTDUR);
        for j = 1:NO_IP_CHANNELS/4
            r2.channel(j).data = [r2.channel(j).data (bg{j}+time_switch(i))];
        end
        flag = 0;
    end
end
target_fn(end: length(t)) = ~target_fn(end);


for i = 1:NO_IP_CHANNELS/4
    I.channel(i).data = sort([r1.channel(i).data  bg_lo{i}]);
    I.channel(i).spiking = 1;
    I.channel(i).dt = -1;
    I.channel(i+NO_IP_CHANNELS/4).data = sort([r2.channel(i).data bg_lo{NO_IP_CHANNELS/4+i}]);
    I.channel(i+NO_IP_CHANNELS/4).spiking = 1;
    I.channel(i+NO_IP_CHANNELS/4).dt = -1;
end
%-------------------------------------------------------------------------
%possible_rates = [10 30 50 70 90];
possible_rates = [30 90];

for i = 1:2
    r.channel(i).data = [];
end
for i = 1:lent
    if(rem(i,(100e-3/DT))==0 || i == 1)
       for j = 1:2
            choice = randperm(2);
            choice = choice(1);
            r.channel(j).data = [r.channel(j).data possible_rates(choice)];
       end 
    else
       for j = 1:2
            r.channel(j).data = [r.channel(j).data r.channel(j).data(end)];
       end 
    end
end

% channels 1- 8 are created here
bg1 = rate2spikes(r.channel(1).data, DT, NO_IP_CHANNELS/2, TSTIM);
% channels 9-16 are created here
bg2 = rate2spikes(r.channel(2).data, DT, NO_IP_CHANNELS/2, TSTIM);

for i = 17:NO_IP_CHANNELS
    if(i <=24)
        I.channel(i).data = bg1{i-16};
    else
        I.channel(i).data = bg2{i-24};
    end
    I.channel(i).spiking = 1;
    I.channel(i).dt = -1;
end

% Now make the feedback channels which simulate the feedback from the pool
% of spiking readouts
%[data, sor] = target_function_of_discrete_attractor(I, LOVAL, HIVAL,...
%                                       dt, Tstim, RLO, RHI);
data = target_fn;
for i = 1:NO_FB_CHANNELS
    % generate a gaussian with mean=RATE_READOUT & SD=RATE_NOISE
    rate = generate_gaussian(RATE_READOUT, RATE_NOISE, lent);
    rate(data==0) = round(BASE_RATE*rand(1,length(data(data==0))) );
    %rate(data==0) = 0;
    bg = rate2spikes(rate, dt, 1, Tstim);
    spktrn = bg{1};
    %delay = randperm(10);
    %delay = delay(find(delay>0));
    %delay = delay(1)*DT;
    delay = DT;
    I.channel(NO_IP_CHANNELS+i).data = spktrn+delay;
    I.channel(NO_IP_CHANNELS+i).spiking = 1;
    I.channel(NO_IP_CHANNELS+i).dt = -1;
end

% --- Add some information to the stimulus ----
I.info(1).dt              = dt;
I.info(1).Tstim         = Tstim;
I.info(1).data = data;

I.info(1).roch1_val = values_for_roch1(I);
I.info(1).roch2_val = values_for_roch2(I);
I.info(1).rofb_val = values_for_rofb(I);
I.info(1).roprod_val = values_for_roprod(I);
I.info(1).roampl_val = values_for_roampl(I);
I.info(1).roattn_val = values_for_roattn(I);
