function op = values_for_car(Stim)
global DT TSTIM KERNEL_SIZE

time = (0:DT:TSTIM);

channel1 = sort([Stim.channel(1:8).data]);
channel2 = sort([Stim.channel(9:16).data]);

op = [0];
MULFAC = 0.01;
for i = 2:length(time)
    lotime = time(i-1);
    hitime = time(i);
    nSpikesChannel1 = length(find(channel1>=lotime & channel1 <=hitime));
    nSpikesChannel2 = length(find(channel2>=lotime & channel2 <=hitime));
    op(i) = op(i-1) + (nSpikesChannel1 - nSpikesChannel2)*MULFAC;
end
op = lpf(op, KERNEL_SIZE/DT);

