function [y] = target_function_of_discrete_attractor(S, dt, Tstim, ...
                                                     threshLo, threshHi)
%-------------------------------------------------------------------------
% Desc - This function computes the target function of the discrete
%        attractor which has been smoothed along the transit points.
%
%        (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------
t = (0:dt:Tstim);

sor = S.channel(17).data;
channels1 = make_event_channels(sor, threshLo, threshHi, dt, Tstim);
r2val = values_for_rate2(S); 
 
isup = channels1(2).isup;
data = zeros(size(isup));
data(isup==0) = 0;
idx = find(isup ==1);
data(idx) = r2val(idx);
y = data;


