%-------------------------------------------------------------------------
% Desc - This part of the code performs the closed loop validation process.
%        First it converts the open loop readout to a closed loop readout
%        and then perform the simulation in a closed loop with new unseen 
%        inputs for validation.
%
%        (c), 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

global FBSCALE BASEVAL
global RESULT_PATH
fprintf('\n--------------------------------------------------------');
fprintf('\n\nNow starting the closed loop validation  process for %s\n\n', RESULT_PATH);
fprintf('--------------------------------------------------------\n');

%-------------------------------------------------------------------------
% Part I - Construct the transformed liquid
%-------------------------------------------------------------------------
[nmc, roIdx1] = transform_readout(nmc, trained_readouts{1});
[nmc, roIdx2] = transform_readout(nmc, trained_readouts{2});
[nmc, roIdx3] = transform_readout(nmc, trained_readouts{3});
[nmc, roIdx4] = transform_readout(nmc, trained_readouts{4});
[nmc, roIdx5] = transform_readout(nmc, trained_readouts{5});

% find the Teacher Feedback Neuron
pools = get(nmc, 'pool');
poolinp = pools(2);
teacher_fb_neuron = poolinp.neuronIdx;
tfbIdx = teacher_fb_neuron(1);

% rescale the synapses from teacher feedback neuron to the circuit
[pre, post] = csim('get', tfbIdx, 'connections');
for i = 1:length(post)
   wOld = csim('get', post(i), 'W');
   csim('set', post(i), 'W', wOld * FBSCALE);
end


% Create feedback connections
csim('connect', teacher_fb_neuron(1), roIdx5);

% Switch feedback on
csim('set', teacher_fb_neuron(1), 'feedback', 1);
%csim('set', teacher_fb_neuron(1), 'feedback_delay', 10);

% add recorder to record the output of our transformed readouts.
rec = csim('create', 'Recorder');
csim('set', rec, 'dt', DT);
csim('connect', rec, roIdx1, 'output');
csim('connect', rec, roIdx2, 'output');
csim('connect', rec, roIdx3, 'output');
csim('connect', rec, roIdx4, 'output');
csim('connect', rec, roIdx5, 'output');



%-------------------------------------------------------------------------
% Part II - Collect the stimulus response pairs for validation
%-------------------------------------------------------------------------
%fprintf('\n--------------------------------------------------------');
%fprintf('\n\nCollecting the stimulus-response pairs for validation\n\n');
%fprintf('--------------------------------------------------------\n');
%[val_response,val_stimuli] = collect_sr_data_new(nmc, ...
%                                                     TrainDist,...
%                                                     NVALIDATE, ...
%                                                     TSTIM);


%-------------------------------------------------------------------------
% Part III - Perform Validation
%-------------------------------------------------------------------------
tic;
fprintf('\n--------------------------------------------------------');
fprintf('\n\nRunning %i simulations in closed loop\n\n', NVALIDATE);
fprintf('--------------------------------------------------------\n');
plot_labels = {'rate of channels 1-8' 'readout 1 - continuous attractor' 'switch based on car' 'car'};
for i = 1 :NVALIDATE
    if(mod(i, 10) == 0)
        fprintf('\n\nClosed loop validation run number %g\n\n', i);
    end;
    S = val_stimuli(i);
    S.channel(17).data = FBSCALE * (S.channel(17).data + BASEVAL);
    %S.channel(17).data = S.channel(17).data + 40;
    [R] = wo_delay_validate(nmc, trained_readouts, S);

    traces = csim('get', rec, 'traces');

     % now save the data
    [fname, err] = sprintf('%s/run%g.mat', RESULT_PATH, i);
    save(fname, 'S', 'traces', 'R', 'DT', 'TSTIM')       

end;
