function [r1, r2] = make_rate_function(isFixed)
%-------------------------------------------------------------------------
% Desc - This function makes 2 rates such that the value of (r1 - r2) is:
%        (A) Stationary for the first 150 msec
%        (B) increasing for the next 150 msec
%        (C) constant again for the next 50 msec
%        (D) decreasing for the next 150 msec
%
%         (c) 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

global DT TSTIM
time = (0:DT:TSTIM);

t1 = time(find(time <=50e-3));
t2 = time(find(time >50e-3 & time <= 150e-3));
t3 = time(find(time > 150e-3 & time <=300e-3));
t4 = time(find(time > 300e-3 & time <=400e-3));
t5 = time(find(time > 400e-3 & time <=550e-3));
t6 = time(find(time > 550e-3 & time <=650e-3));
t7 = time(find(time > 650e-3 & time <=TSTIM));

RATE_LO = [10 20 30];
RATE_FIX = [50 60];
RATE_HI = [80 90 100];

% make the first stationary part
choice = randperm(2);
choice = choice(1);
r1Part1 = RATE_FIX(choice) * ones(size(t1));
r2Part1 = RATE_FIX(choice) * ones(size(t1));

% make the part that increases
choiceHi = randperm(3);
choiceHi = choiceHi(1);
choiceLo = randperm(3);
choiceLo = choiceLo(1);
r1Part2 = RATE_HI(choiceHi) * ones(size(t2));
r2Part2 = RATE_LO(choiceLo) * ones(size(t2));

% make the part thats stationary again
choice = randperm(2);
choice = choice(1);
r1Part3 = RATE_FIX(choice) * ones(size(t3));
r2Part3 = RATE_FIX(choice) * ones(size(t3));

% make the part that decreases
choiceHi = randperm(3);
choiceHi = choiceHi(1);
choiceLo = randperm(3);
choiceLo = choiceLo(1);
r1Part4 = RATE_LO(choiceLo) * ones(size(t4));
r2Part4 = RATE_HI(choiceHi) * ones(size(t4));

% make the part thats stationary again
choice = randperm(2);
choice = choice(1);
r1Part5 = RATE_FIX(choice) * ones(size(t5));
r2Part5 = RATE_FIX(choice) * ones(size(t5));

% make the part that increases
choiceHi = randperm(3);
choiceHi = choiceHi(1);
choiceLo = randperm(3);
choiceLo = choiceLo(1);
r1Part6 = RATE_HI(choiceHi) * ones(size(t6));
r2Part6 = RATE_LO(choiceLo) * ones(size(t6));

% make the part thats stationary again
choice = randperm(2);
choice = choice(1);
r1Part7 = RATE_FIX(choice) * ones(size(t7));
r2Part7 = RATE_FIX(choice) * ones(size(t7));

% now combine them
r1 = [r1Part1 r1Part2 r1Part3 r1Part4 r1Part5 r1Part6 r1Part7];
r2 = [r2Part1 r2Part2 r2Part3 r2Part4 r1Part5 r2Part6 r2Part7];

if(isFixed == 1)
    r1Part1 = 50 * ones(size(r1Part1));
    r1Part2 = 100 * ones(size(r1Part2));
    r1Part3 = 60 * ones(size(r1Part3));
    r1Part4 = 10 * ones(size(r1Part4));
    r1Part5 = 50 * ones(size(r1Part5));
    r1Part6 = 100 * ones(size(r1Part6));
    r1Part7 = 60 * ones(size(r1Part7));
    
    r2Part1 = 50 * ones(size(r2Part1));
    r2Part2 = 10 * ones(size(r2Part2));
    r2Part3 = 60 * ones(size(r2Part3));
    r2Part4 = 100 * ones(size(r2Part4));
    r2Part5 = 50 * ones(size(r2Part5));
    r2Part6 = 10 * ones(size(r2Part6));
    r2Part7 = 60 * ones(size(r2Part7));
    r1 = [r1Part1 r1Part2 r1Part3 r1Part4 r1Part5 r1Part6 r1Part7];
    r2 = [r2Part1 r2Part2 r2Part3 r2Part4 r1Part5 r2Part6 r2Part7];
end;
