function this = make_inputs()
  global NTRAIN NTEST NVALIDATE INPUT_PATH

  %create the training samples
  generateIP(NTRAIN, INPUT_PATH, 'trn');

  % create testing samples
  generateIP(NTEST, INPUT_PATH, 'tst');
  
  % create validation samples
  generateIP(NVALIDATE, INPUT_PATH, 'vld');


function this=generateIP(noSample,path, prefix)
%-------------------------------------------------------------------------
% Desc - This file generates the 16 input channels of which 8 are drawn with
%        one rate and 8 with another rate, both of which have been drawn randomly.
%        Also produces one channel of TFB stimuli.
%
%        (c), 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

global DT TSTIM NO_IP_CHANNELS NO_FB_CHANNELS

t=0:DT:TSTIM;
lent = length(t);

for idx = 1:noSample

    [r1, r2] = make_rate_function(0);

    bg1 = rate2spikes(r1, DT, 8, TSTIM);
    bg2 = rate2spikes(r2, DT, 8, TSTIM);

    for i = 1:NO_IP_CHANNELS
        if(i<=8)
            I.channel(i).data = bg1{i};
        else
            I.channel(i).data = bg2{i-8};
        end
        I.channel(i).spiking = 1;
        I.channel(i).dt = -1;
    end

    op = values_for_car(I);
    I.channel(17).data = add_noise([0 op(1:end-1)]);
    I.channel(17).spiking = 0;
    I.channel(17).dt = DT;

    % --- Add some information to the stimulus ----
    I.info(1).Tstim = TSTIM;
    I.info(1).r1 = r1;
    I.info(1).r2 = r2;
    I.info(1).carval = op;
    I.info(1).ro1val = values_for_ro1(I);
    I.info(1).rate2val = values_for_rate2(I);
    I.info(1).ro2val = values_for_ro2(I);
    I.info(1).car_switch_val = values_for_car_switch(I);;
    [fname, err] = sprintf('%s/%s%g.mat', path, prefix, idx);
    save(fname, 'I');
  end
    
