function channels = make_event_channels(sor, rlo, rhi, dt, Tstim)
%-------------------------------------------------------------------------
% Desc - This function makes the channels 3 and 4. Channel 3 is spiking
%        with rate rlo, when the sor is lower then rlo. Channel 4 is 
%        spiking with a rate rhi when the sor is higher then rhi.
%        Assuming that the max rate is 100Hz.
%
%        (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------
t = (0:dt:Tstim);
len = length(t);


%--- Find the event times ---
%-- define the current event 0 - low; 1 - up --
curevent = -1;
upevent = [];
loevent = [];
upcnt = 0;
locnt = 0;
channels(1).isup = [];
channels(2).isup = [];
for i = 1:len
    if(sor(i) >= rhi && curevent ~= 1)
        curevent = 1;
        upcnt = upcnt+1;
        if(i ~= len)
            upevent(upcnt).starttime = t(i+1);
        else
            upevent(upcnt).starttime = Tstim;
        end;
    end;
    if(sor(i) <= rlo && curevent ~= 0)
        curevent = 0;
        locnt = locnt+1;
        if(i ~= len)
            loevent(locnt).starttime = t(i+1);
        else
            loevent(locnt).starttime = Tstim;
        end;
    end;
    if(curevent == -1)
        channels(1).isup = [channels(1).isup 0];
        channels(2).isup = [channels(2).isup 0];
    end;
    if(curevent == 1)
        channels(1).isup = [channels(1).isup 0];
        channels(2).isup = [channels(2).isup 1];
    end;
    if(curevent == 0)
        channels(1).isup = [channels(1).isup 1];
        channels(2).isup = [channels(2).isup 0];
    end;
end;

if(upcnt ~=0)
    for i = 1:upcnt
        if(locnt == 0)
            upevent(i).endtime = Tstim;
        else
            idx = find([loevent(:).starttime] > upevent(i).starttime);
            if(isempty(idx))
                endtime = Tstim;
            else
                endtime = loevent(idx(1)).starttime;
            end;
            upevent(i).endtime = endtime;
        end;
    end;
end;

if(locnt ~=0)
    for i = 1:locnt
        if(upcnt == 0)
            loevent(i).endtime = Tstim;
        else
            idx = find([upevent(:).starttime] > loevent(i).starttime);
            if(isempty(idx))
                endtime = Tstim;
            else
                endtime = upevent(idx(1)).starttime;
            end;
            loevent(i).endtime = endtime;
        end;
    end;
end;

%--- Now make two spike trains for Tstim time -------

r1 = ones(size(t))*50; % the channel detecting the lo event will fire at 50 Hz.
r2 = ones(size(t))*60; % The channel detecting the hi event will fire at 60 Hz.
strain_lo =rate2spikes(r1, 1e-3, 1,Tstim); 
strain_hi =rate2spikes(r2, 1e-3, 1,Tstim);
strain_lo = strain_lo{1};
strain_hi = strain_hi{1};

upidx = [];
loidx = [];
if(upcnt ~=0)
    for i = 1:upcnt
        upidx = [upidx find(strain_hi >= upevent(i).starttime & strain_hi <= upevent(i).endtime)];
    end;
    strain_hi = strain_hi(upidx);
end;


if(locnt ~=0)
    for i = 1:locnt
        loidx = [loidx find(strain_lo >= loevent(i).starttime & strain_lo <= loevent(i).endtime)];
    end;
    strain_lo = strain_lo(loidx);
end;
channels(1).data = strain_lo;
channels(2).data = strain_hi;
