%--------------------------------------------------------------------------
% Desc - This file defines the parameters for the simulation
%
%            (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%--------------------------------------------------------------------------
global NO_FB_CHANNELS NO_IP_CHANNELS TSTIM DT KERNEL_SIZE 
global NKERNELS CHANNELS_PER_RATE
global NTRAIN NTEST INPUT_PATH NVALIDATE
global FBSCALE BASEVAL
global RESULT_PATH
%--------------------------------------------------------------------------
% Simulation Parameters
%--------------------------------------------------------------------------

% the time step of simulation in seconds
DT = 2e-3;

% the total time of simulation in seconds
TSTIM = 700e-3;

% the higher the value the more the plots that will be generated
PLOTTING_LEVEL = 0;

% number of training iterations
NTRAIN = 200;

% number of testing iterations
NTEST = 50;

% number of validation runs
NVALIDATE = 100;

% The path where the input data is stored
INPUT_PATH = './data/inputs';
CIRCUIT_PATH = './data/circuit';

% The size of kernel window for the open loop readouts
KERNEL_SIZE = 30e-3;

% The number of gaussian kernels used in perturbation experiment.
NKERNELS = 10;

CHANNELS_PER_RATE = 8;

REGEN_CIRCUIT = 1;
REGEN_DATA      = 0;

% the feedback scale
FBSCALE = 1; % setting this parameter between 0 and 1 runs the simulation with
             % various feedback strengths (for figure 6).
BASEVAL = 0.65;
[fn,e] = sprintf('./results_%g/w', FBSCALE*100);
RESULT_PATH = fn;

%-------------------------------------------------------------------------
% Parameters from Stefan's model
%-------------------------------------------------------------------------
noise = 1;
A = 34636e-12; % [m]

gl = 0.045e-3/1e-4*A; % [S]
Rm = 1/gl;
Cm = 1e-6/1e-4*A;

Vresting = -80e-3;         % Volt
Vinit    = [-70e-3 -60e-3];
Iinject = [0 0];

%nn_scaling = 25/prod(layer_base);

ge0 = 0.012e-6;   % parameters for Ornstein-Uhlenbeck noise
% sig_e = 0.012e-6;
sig_e = 0.003e-6*(noise~=0);
tau_e = 2.7e-3;

gi0 = 0.057e-6;
% sig_i = 0.0264e-6;  
sig_i = 0.0066e-6*(noise~=0);  
tau_i = 10.5e-3;

Ee = 0e-3;
Ei = -75e-3;

%--------------------------------------------------------------------------
% Liquid parameters
%--------------------------------------------------------------------------

% circuit type
nmc = neural_microcircuit;

% number of layers
NO_LAYERS = 3;

% neuron type
NTYPE_CIRCUIT = 'LifNeuron';
NTYPE_IP = 'SpikingInputNeuron';
NTYPE_TFB = 'AnalogFeedbackNeuron';

% synapse types
STYPE_IP = 'StaticSpikingSynapse';
STYPE_TFB = 'StaticAnalogSynapse';
STYPE_CIRCUIT ='DynamicSpikingSynapse';

% circuit size
CIRCUIT_SIZE = [5 5 24];

% number of input channels (excluding feedback)
NO_IP_CHANNELS = 16;

% number of readouts
NO_READOUTS = 1;
NO_FB_CHANNELS = NO_READOUTS;

% define the origin of input pool, liquid and the linear readout
ORIG_POOL_NMC = [6 0 4];
ORIG_POOL_IP  = [1 1 12];
ORIG_POOL_FB  = [2 1 15];

% set the connection parameters
SF = 0.3;
scaleFac = 2/100;

% for connections from ip --> liq
wsip2liq  = 1e-1* 0.5 * SF;
csip2liq  = 10;
lamip2liq = 5;

% for connection that simulate teacher feedback
%wsfb   = 1/5 * 1/40 * 0.4 * SF;
wsfb   = 0.08 * SF;
csfb = 10;
lamfb  = 5;

% for recurrent connections liq --> liq
%wsliq = 0.1 * 2 * scaleFac;
wsliq  = 2 * scaleFac;
csliq  = 1;
lamliq = 3;
