%--------------------------------------------------------------------------
% Desc - This files launches the experiment with the continuous spiking
%             readouts.
%
%            (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%--------------------------------------------------------------------------
clear all classes;
close all;


%-------------------------------------------------------------------------
% Load the simulation parameters and create the liquid
%-------------------------------------------------------------------------
load_params;
clc;
fprintf('\n\n****\n\nRunning simulation with %g percent feedback strength \n\n****\n\n', FBSCALE*100);
if(REGEN_CIRCUIT == 1)
    make_liquid;
else
    [fn,e] = sprintf('%s/nmc.mat', CIRCUIT_PATH);
    load(fn);
end

if(REGEN_DATA == 1)
   make_inputs;
end;


%-------------------------------------------------------------------------
% Create the stimulus object
%-------------------------------------------------------------------------
TrainDist = cont_attr_stimulus;
S = generate(TrainDist, 'trn1');
S.channel(17).data = FBSCALE * (S.channel(17).data + BASEVAL);
if(PLOTTING_LEVEL >0)
    figure(1);
    plot(TrainDist, S);
    drawnow;
    figure(2);
    plot_circuit_resp;
    drawnow;
end
anykey;
%-------------------------------------------------------------------------
% PART 1 - TRAINING OF A LINEAR READOUT
%-------------------------------------------------------------------------

% collect the stimulus and response pairs for training and testing
[train_response,train_stimuli] = collect_sr_data_new(nmc, ...
                                                     TrainDist,...
                                                     NTRAIN, ...
                                                     TSTIM,...
                                                     'trn');
[test_response,test_stimuli] = collect_sr_data_new(nmc, ...
                                                     TrainDist,...
                                                     NTEST, ...
                                                     TSTIM,...
                                                     'tst');

ltrain_val  = response2states(train_response,[], ...
                             [0:DT:TSTIM]);%, ...
                             %{ 'spikes2alpha' 0.05 });
ltest_val  = response2states(test_response,[], ...
                             [0:DT:TSTIM]);%, ...
                             %{ 'spikes2alpha' 0.05 });

% add the readouts
readout{1} = external_readout('targetFunction',ro1,...
                      'description','rate of channel 1-8');
readout{2} = external_readout('targetFunction',rate2,...
                      'description','rate of channel 9-16');
readout{3} = external_readout('targetFunction',ro2,...
                      'description','rate of channel 1 - CAR');
readout{4} = external_readout('targetFunction',car_switch,...
    'description','switch readout');
readout{5} = external_readout('targetFunction',car,...
    'description','continuous attractor readout');

[trained_readouts] = train_readouts(readout,ltrain_val, train_stimuli,...
                                                        ltest_val, test_stimuli);
% plot the output of the trained readouts of the test data
%VERBOSE_LEVEL  = 1;
%figure;
 
%best_example = plot_readouts(trained_readouts,test_response,test_stimuli,...
%                             { 'response2states' [0:DT:TSTIM] {'spikes2exp' 0.03}} );  

% generate a validation set with NVALIDATE inputs.
fprintf('\n\n***\ngenerating validation data\n***\n\n');
for i = 1:NVALIDATE
    [fname, e] = sprintf('vld%g', i);
    val_stimuli(i) = generate(TrainDist, fname);
end
% save the important variables
[fn,e] = sprintf('%s/workspace.mat', RESULT_PATH);
save(fn, 'nmc', 'trained_readouts', 'TrainDist', 'val_stimuli');

%-------------------------------------------------------------------------
% run in closed loop setup with real weights
%-------------------------------------------------------------------------
clear all classes;
close all;
load_params;
[fn,e] = sprintf('%s/workspace.mat', RESULT_PATH);
load(fn);
online_validation;


