function this = grr(varargin)

this.description     = 'genarates spike trains with a rate modulated by r(t) which is drawn randomly';

this.nChannels         = 4;
this.nChannels_comment = 'number of spiking channels per group';

this.nGroups           = 4;
this.nGroups_comment   = 'number of independent groups for which r(t) is generated';

this.Tstim             = -1; % if set to -1 we set Tstim to Tmax (in generate.m)
this.Tstim_comment     = 'length of stimulus (-1 ... specify the length in the call to generate)';

this.f              = 80;
this.f_comment      = 'maximal rate of a single channel';

this.binwidth          = 2e-4;
this.binwidth_comment  = 'in each interval of length binwidth a new random rate is drawn';

this.gcc            = 0.5 * ones(1, this.nGroups);
this.gcc_comment    = 'correlation coefficient within group [1xnGroups]';

this.public_properties = { 'nGroups' 'nChannels' 'Tstim' 'f' 'binwidth' 'gcc'};


[pathstr,name,ext,versn] = fileparts(mfilename);
if nargin == 0
  this = class(this,name);
elseif isa(varargin{1},name)
  this = varargin{1};
else
  this = class(this,name);
  this = set(this,varargin{:});
end
