function S=generate(this,argTstim,varargin)

if nargin < 2, argTstim = -1; end

if this.Tstim > -1, Tstim=this.Tstim; else Tstim=argTstim; end

if Tstim <= 0
  error('length of stimulus undefined!');
end

S.channel(this.nChannels*this.nGroups).data = [];

% tic

ii=0;
for g=1:this.nGroups

  rsp = rand(1, floor(Tstim/this.binwidth)) <= this.f * this.binwidth;

  ccg = sqrt(this.gcc(g));
  theta = this.f * this.binwidth * (1 - ccg) + ccg;
  phi = this.f * this.binwidth * (1 - ccg);

  for i=1:this.nChannels
    st1 = find(rsp == 0);
    st1 = st1(rand(size(st1)) <= phi);

    st2 = find(rsp == 1);
    st2 = st2(rand(size(st2)) <= theta);

    st = sort([st1 st2]) * this.binwidth;
    ii=ii+1; S.channel(ii).data = st;
  end

  % [toc/60, toc/g*this.nGroups/60]

end

[S.channel.spiking]                = deal(1);
[S.channel.dt]                     = deal(-1);
S.info(1).Tstim  = Tstim;
