function S=generate(this,argTstim,varargin)

if nargin < 2, argTstim = -1; end

if this.Tstim > -1, Tstim=this.Tstim; else Tstim=argTstim; end

if Tstim <= 0
  error('length of stimulus undefined!');
end

S.channel(this.nChannels*this.nGroups).data = [];

ii=0;
tic
dt=1e-3;
t=0:this.binwidth:Tstim;
for g=1:this.nGroups
  %
  % generate random r(t)
  %
  r=rand(size(t))*this.fmax;

  %
  % this is 80 times faster then r=interp1(t,r,tt,'nearest'); 
  %
  r=repmat(r,[this.binwidth/dt 1]);
  r=reshape(r,1,prod(size(r)));

  for i=1:this.nChannels
    st=find(rand(size(r))<r*dt)*dt;
    if ~isempty(st)
      st = st + dt*rand(size(st));
    end
    st(st>Tstim)=[];
    ii=ii+1; S.channel(ii).data = st;
  end

  %[toc/60, toc/g*this.nGroups/60]

end

[S.channel.spiking]                = deal(1);
[S.channel.dt]                     = deal(-1);
S.info(1).Tstim  = Tstim;
