#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "csimerror.h"

csimError TheCsimError;

void csimError::add(const char* fmt, ...)
{
  va_list ap;
  int nChars = strlen(message);
  while (1) {
    /* Try to print in the allocated space. */
    va_start(ap, fmt);
#ifdef _WIN32
    int n = vsprintf (message+nChars, fmt, ap);
#else
    int n = vsnprintf (message+nChars, lMessage-nChars-1, fmt, ap);
#endif
    va_end(ap);
    /* If that worked, return else alloc more memory */
    if (n > -1 && n < lMessage-nChars-1 ) {
      return;
    } else {
      lMessage *= 2;
      message = (char *)realloc(message,lMessage*sizeof(char));
    }
  }
}

#ifdef __TEST__

// if you run on the following on the shell prompt
// 1.) g++ -D__TEST__ csimerror.cpp -o test
// 2.) ./test
// the functionality of the class should be pretty clear.

main(void)
{
  csimError err;

  err.add("error 1: %g %i %s\n",1.23,454,"hallo");
  err.add("error 2: %g %i %s\n",2.22,333,"hallo2");
  err.add("error 3: %g %i %s\n",2.22,333,"hallo2");
  err.add("error 4: %g %i %s\n",2.22,333,"hallo2");
  err.add("error 5: %g %i %s\n",2.22,333,"hallo2");
  err.add("error 6: %g %i %s\n",2.22,333,"hallo2");
  err.add("error 7: %g %i %s\n",2.22,333,"hallo2");
  err.add("error 8: %g %i %s\n",2.22,333,"hallo2");
  err.add("error 9: %g %i %s\n",2.22,333,"hallo2");

  printf("%s",err.msg());

}

#endif
