/*! \file stdpsynapse.h
**  \brief Class definition of StdpSynapse
*/

#ifndef _STDPSYNAPSE_H_
#define _STDPSYNAPSE_H_

#include "spikingsynapse.h"
#include "needspostspikesynapse.h"

//! Base class for all  spiking synapses with spike time dependent plasticity (STDP)
class StdpSynapse : public SpikingSynapse {
 public:

  //! The constructor ...
  StdpSynapse(void);

  // Called if the postsynaptic neuron emmits a spike
  // virtual void preSpikeNotify(int iNewSpike);

  //! Called if the postsynaptic spikes hits (arrives at) the synapse
  virtual int preSpikeHit(void);

  //! Called if the postsynaptic spikes hits (arrives at) the synapse (inherited from NeedsPostSpikeSynapse)
  virtual int postSpikeHit(void);

  //! connect the presynaptic neuron
  virtual int addIncoming(Advancable *a);

  //! connect the postsynaptic neuron
  virtual int addOutgoing(Advancable *a);

  //! The method which does the actual STDP learning, i.e. changes one (ore more) parameters of the synapse.
  virtual void stdpLearning(double delta, double epost, double epre);

  //! Defines the model (static, dynamic) how the PSR is increased if a spike hits the synapse
  virtual void stdpChangePSR(void){};

  //! The maximum value of \f$Delta = t_{post}-t_{pre}\f$ which should be considered for STDP. [units=sec; range=(0,+100);]
  // float Tmax;

  //! The minimum value of \f$Delta = t_{post}-t_{pre}\f$ which should be considered for STDP. [units=sec; range=(-100,0);]
  // float Tmin;

  float back_delay;

  float tauspost;
  float tauspre;

  float taupos;
  float tauneg;

  float dw;
  float STDPgap;
  int activeSTDP;
  int useFroemkeDanSTDP;

  //! The maximal/minimal weight of the synapse [readwrite; units=;]
  float Wex;

  float Aneg;
  float Apos;
  
  float mupos;
  float muneg;

};

#endif
