/*! \file analogfeedbackneuron.cpp
**  \brief Implementation of AnalogFeedbackNeuron
*/

#include "analogfeedbackneuron.h"
#include "csimerror.h"

AnalogFeedbackNeuron::AnalogFeedbackNeuron(void)
{
  feedback = EXTERNAL_INPUT;
  feedback_delay = 0;
  delay_over=0;
}

double AnalogFeedbackNeuron::nextstate(void)
{
  if (feedback == EXTERNAL_INPUT) {
    // Take external input
    return (VmOut=Vm=nextValue(0)+Vresting);
  }
  else {
    if (delay_over < 1) {
      // Fetch external input
      csimInputChannel *s;
      int k;
      if ( (s=getChannel(0)) != 0 ) {
	k=(int)(SimulationTime/s->dt + 0.5);
      }
      else return 0.0;
      if (( k<s->length ) && ( k < feedback_delay)) {
	// External input
	return (VmOut=Vm=nextValue(0)+Vresting);
      }
      else {
	// Switch to feedback mode
	delay_over = 1;
      }
    }


    // Receive internal feedback
    VmOut=Vm=summationPoint;
    summationPoint = 0;
    return VmOut;
  }
}

void AnalogFeedbackNeuron::reset(void)
{
  AnalogInputNeuron::reset();
  delay_over=0;
}

int AnalogFeedbackNeuron::addIncoming(Advancable *a)
{
  Synapse *syn;
  if ( (syn=dynamic_cast<Synapse *>(a)) ) {
    // Make normal connection
    return Neuron::addIncoming(a);
  }

  // Other input (like readout) is allowed but not stored
  return 0;
}

int AnalogFeedbackNeuron::addOutgoing(Advancable *S)
{
  return AnalogInputNeuron::addOutgoing(S);
}


//! Toggles the feedback-mode of the neuron
int AnalogFeedbackNeuron::switchMode(int feedback_mode) {
  if ((feedback_mode == EXTERNAL_INPUT) || (feedback_mode == INTERNAL_FEEDBACK)) {
    feedback = feedback_mode;
  }
  else {
    TheCsimError.add("AnalogFeedbackNeuron::switchMode: Invalid feedback-mode %i!\n", feedback_mode);
    return -1;
  }
}


