function install

% save current working directory
rwd=pwd;

% compile conn.c
cd('@neural_microcircuit/private');
if exist('conn') == 3
  fprintf('conn.%s exists. No compilation necessary.\n',mexext);
else
  fprintf('Compiling conn.%s ...',mexext);
  mex conn.c randgen.c
  fprintf('\b\b\b\b. Done.\nconn.%s successfully compiled.\n',mexext);
end
cd(rwd);

cd('@balanced_fanin_circuit/private');
if exist('rand_conn') == 3
  fprintf('rand_conn.%s exists. No compilation necessary.\n',mexext);
else
  fprintf('Compiling rand_conn.%s ...',mexext);
  mex rand_conn.c randgen.c
  fprintf('\b\b\b\b. Done.\nrand_conn.%s successfully compiled.\n',mexext);
end
if exist('fanin_conn') == 3
  fprintf('fanin_conn.%s exists. No compilation necessary.\n',mexext);
else
  fprintf('Compiling fanin_conn.%s ...',mexext);
  mex fanin_conn.c randgen.c
  fprintf('\b\b\b\b. Done.\nfanin_conn.%s successfully compiled.\n',mexext);
end
cd(rwd);

fprintf('Circuit-Tool *successfully* installed.\n\n');
