function [CT] = generate_CT(parameters)
%GENERATE_CT Generates a fixed set of small microcircuits templates.
%   CT = GENERATE_CT(PAR) generates a cell array of 21 small_microcircuit
%   objects CT using the default parameters PAR.
%
%
%   See also GEN_CIRC_TEMP
%
%   Author: Stefan Haeusler, 10/2002, haeusler@igi.tu-graz.ac.at
if nargin == 0
   error(' ''parameters'' must be specified.')
end

additional_definitions

SH = [0.0 0.0 0.0];
A = NaN;
U = NaN;
D = NaN;
F = NaN;

CT = [];

CT{end+1} = small_microcircuit('C1',[EXZ],[OUT_SYN	1	STATIC	A	U	D	F	SH],parameters);
CT{end+1} = small_microcircuit('C2',[EXZ],[OUT_SYN	1	IEf	A	U	D	F	SH],parameters);
CT{end+1} = small_microcircuit('C3',[EXZ],[OUT_SYN	1	IEd	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C4',[EXZ EXZ],[2	 1	EE	A	U	D	F	SH;...
 			         1	 2	EE	A	U	D	F	SH;...
 			         OUT_SYN 1 	EE	A	U	D	F	SH;...
 			         OUT_SYN 2	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C5',[EXZ EXZ],[2	 1	IEd	A	U	D	F	SH;...
 			         1	 2	IEd	A	U	D	F	SH;...
 			         OUT_SYN 1 	IEd	A	U	D	F	SH;...
 			         OUT_SYN 2	IEd	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C6',[EXZ EXZ],[2	 1	IEf	A	U	D	F	SH;...
 			         1	 2	IEf	A	U	D	F	SH;...
 			         OUT_SYN 1 	IEf	A	U	D	F	SH;...
 			         OUT_SYN 2	IEf	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C7',[EXZ EXZ],[2	 1	F1	A	U	D	F	SH;...
 			         1	 2	F1	A	U	D	F	SH;...
 			         OUT_SYN 1	F1	A	U	D	F	SH;...
 			         OUT_SYN 2	F1	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C8',[EXZ EXZ],[2	 1	F2	A	U	D	F	SH;...
 			         1	 2	F2	A	U	D	F	SH;...
 			         OUT_SYN 1 	F2	A	U	D	F	SH;...
 			         OUT_SYN 2	F2	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C9',[EXZ EXZ],[2	 1	F3	A	U	D	F	SH;...
 			         1	 2	F3	A	U	D	F	SH;...
 			         OUT_SYN 1 	F3	A	U	D	F	SH;...
 			         OUT_SYN 2	F3	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C10',[EXZ EXZ],[2	 1	EE	A	U	D	F	SH;...
			         1	 2	EE	A	U	D	F	SH;...
			         OUT_SYN 1	IEd	A	U	D	F	SH;...
			         OUT_SYN 2	IEf	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C11',[EXZ INH],[1	 1	EE	A	U	D	F	SH;...
	 		         2	 1	IEf	A	U	D	F	SH;...
			         1	 2	F3	A	U	D	F	SH;...
			         2	 2	F2	A	U	D	F	SH;...
			         OUT_SYN 1	EE	A	U	D	F	SH;...
			         OUT_SYN 2	F1	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C12',[EXZ INH],[2	 1	IEd	A	U	D	F	SH;...
			         1	 2	F1	A	U	D	F	SH;...
			         OUT_SYN 1	EE	A	U	D	F	SH;...
			         OUT_SYN 2	F3	A	U	D	F	SH],parameters);


CT{end+1} = small_microcircuit('C13',[EXZ EXZ EXZ],[2	 1	EE	A	U	D	F	SH;...
	 		         	 3	 2	EE	A	U	D	F	SH;...
			         	 3	 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	EE	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C14',[EXZ EXZ EXZ],[2	 1	EE	A	U	D	F	SH;...
	 		         	 3	 2	EE	A	U	D	F	SH;...
			         	 1	 3	EE	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	EE	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C15',[EXZ EXZ EXZ],[2	 1	EE	A	U	D	F	SH;...
	 		         	 3	 2	EE	A	U	D	F	SH;...
			         	 1	 3	EE	A	U	D	F	SH;...
			         	 2	 3	EE	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	EE	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C16',[EXZ INH EXZ],[2	 1	IEf	A	U	D	F	SH;...
	 		         	 3	 2	F1	A	U	D	F	SH;...
			         	 3	 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	F1	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C17',[EXZ INH EXZ],[2	 1	IEd	A	U	D	F	SH;...
	 		         	 3	 2	F2	A	U	D	F	SH;...
			         	 3	 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	F3	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C18',[EXZ INH EXZ],[2	 1	IEf	A	U	D	F	SH;...
	 		         	 3	 2	F3	A	U	D	F	SH;...
			         	 3	 1	EE	A	U	D	F	SH;...
			         	 2	 3	IEd	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	F3	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C19',[EXZ INH EXZ],[3	 1	EE	A	U	D	F	SH;...
	 		         	 1	 3	EE	A	U	D	F	SH;...
			         	 3	 2	F2	A	U	D	F	SH;...
			         	 1	 2	F2	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	F3	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C20',[EXZ INH EXZ],[3	 1	EE	A	U	D	F	SH;...
	 		         	 2	 1	IEd	A	U	D	F	SH;...
	 		         	 1	 1	EE	A	U	D	F	SH;...
	 		         	 1	 2	F2	A	U	D	F	SH;...
			         	 2	 2	F2	A	U	D	F	SH;...
			         	 3	 2	F2	A	U	D	F	SH;...
	 		         	 1	 3	EE	A	U	D	F	SH;...
			         	 2	 3	IEd	A	U	D	F	SH;...
			         	 3	 3	EE	A	U	D	F	SH;...
			         	 OUT_SYN 1	EE	A	U	D	F	SH;...
			         	 OUT_SYN 2	F3	A	U	D	F	SH;...
			         	 OUT_SYN 3	EE	A	U	D	F	SH],parameters);

CT{end+1} = small_microcircuit('C21',[EXZ EXZ EXZ EXZ EXZ EXZ EXZ],...
			[7	 1	EE	A	U	D	F	SH;...
	         	 3	 1	EE	A	U	D	F	SH;...
	         	 7	 2	EE	A	U	D	F	SH;...
	         	 4	 2	EE	A	U	D	F	SH;...
	         	 5	 3	EE	A	U	D	F	SH;...
	         	 5	 4	EE	A	U	D	F	SH;...
	         	 6	 5	EE	A	U	D	F	SH;...
	         	 7	 6	EE	A	U	D	F	SH;...
	         	 3	 7	EE	A	U	D	F	SH;...
	         	 4	 7	EE	A	U	D	F	SH;...
	         	 3	 3	EE	A	U	D	F	SH;...
	         	 4	 4	EE	A	U	D	F	SH;...
	         	 5	 5	EE	A	U	D	F	SH;...
	         	 6	 6	EE	A	U	D	F	SH;...
	         	 7	 7	EE	A	U	D	F	SH;...
	         	 OUT_SYN 1	EE	A	U	D	F	SH;...
	         	 OUT_SYN 2	EE	A	U	D	F	SH;...
	         	 OUT_SYN 3	EE	A	U	D	F	SH;...
	         	 OUT_SYN 4	EE	A	U	D	F	SH;...
	         	 OUT_SYN 5	EE	A	U	D	F	SH;...
	         	 OUT_SYN 6	EE	A	U	D	F	SH;...
	         	 OUT_SYN 7	EE	A	U	D	F	SH],parameters);





