/*! \file staticanalogsynapse.cpp
**  \brief Implementation of StaticAnalogSynapse
*/

#include "staticanalogsynapse.h"
#include "randgen.h"
#include "stdio.h"

StaticAnalogSynapse::StaticAnalogSynapse(void)
{
  psr = psi = 0;
  W = 1;
}

void StaticAnalogSynapse::reset(void)
{
  advance();
}

int StaticAnalogSynapse::advance(void)
{
  if ( Inoise > 0.0 )
    psr = psi * W + normrnd() * Inoise;
  else
    psr = psi * W;
  
  (*summationPoint) += psr;


  return 1;
}
