/*! \file cbstouneuron.h
**  \brief Implementation of conductance based neurons with Ornstein Uhlenbeck process noise
*/

#ifndef _CB_ST_OU_NEURON_H_
#define _CB_ST_OU_NEURON_H_

#include "cbneuronst.h"
#include "spikingneuron.h"
#include "ionchannel.h"

//! A single compartment neuron with an arbitrary number of channels, current supplying synapses and spike template.
/** Missing!
 ***/
class CbStOuNeuron : public CbNeuronSt {

 DO_REGISTERING

 public:

  CbStOuNeuron(void);
  virtual ~CbStOuNeuron() {};

  virtual double nextstate(void);

  virtual void reset(void);

  //! exc and inh conductances (noise) [readwrite; units=S;]
  double ge,gi;

  //! exc and inh mean conductances (noise) [readwrite; units=S;]
  double ge0,gi0;

  //! time constants and std for exc and inh conductances (noise) [readwrite; units=S;]
  double tau_e,tau_i,sig_e,sig_i;

  //! Reversal potential for exc and inh currents (noise) [readwrite; units=V;]
  double Ee,Ei;

 protected:

 //! noise input current
  double OuInoise;

 //! noise input conductance
  double OuGnoise;

 private:

  //! constant for Ornstein Uhlenbeck process [hidden;]
  double Ae,Ai,Ce,Ci,De,Di;

};

#endif
