/** \file threshmodel.h
**  \A model which receives an analog input and converts it into 
**  \threshold output
**  \Header file for the class
**  \ (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
*/

#ifndef _THRESHMODEL_H_
#define _THRESHMODEL_H_

#include "physicalmodel.h"
#include <string>

using namespace std;

//! Test class of physical model, for an arm. WITHOUT DELAY!!
class ThreshModel : public PhysicalModel
{
    DO_REGISTERING
    public:
    /** Constructs a new Threshold model. */
    ThreshModel();
    virtual ~ThreshModel(void);
    /** Transforms the current inputs to new output values.
       \param I Array of pointers to input values from the readouts.
       \param O Array of output values.
       \return -1 if an error occured, 1 for success. */
    int transform(double** I, double* O);

    /** This function is called after parameters are updated. */
    int updateInternal();
    
    //! The time-step of simulation.
    double model_DT;
    
    private:
    //! Number of timesteps in simulation  \internal [hidden;]
    int TIMESTEPS;

    //! Current time step (in outside, not simulation time. One time step corresponds to one time-step within input files) \internal [hidden;]
    int cur_timestep;

    //! Number of simulation time-steps between file-time-steps  \internal [hidden;]
    int nr_file_steps;

    //! Counts simulation steps between file-steps  \internal [hidden;]
    int sim_step_counter;

    //! Buffer for outputs (if you want to use delay) \internal [hidden;]
    double **out_buffer;
    
    //! Length of the buffer \internal [hidden;]
    int buffer_length;
    
    //! Position inside the buffer \internal [hidden;]
    int buffer_position;
};

#endif
