/*! \file cbneuronst.h
**  \brief Class definition of CbNeuron
*/

#ifndef _CBNEURON_ST_H_
#define _CBNEURON_ST_H_

#include "cbneuron.h"
#include "spikingneuron.h"
#include "ionchannel.h"

//! A single compartment neuron with an arbitrary number of channels, current supplying synapses and spike template.
/** Missing!
 ***/
class CbNeuronSt : public CbNeuron {

 DO_REGISTERING

 public:

  CbNeuronSt(void) { STempHeight=30e-3; Trefract=5e-3; };
  virtual ~CbNeuronSt() {};

  virtual double nextstate(void);

  //! Height [readwrite; units=Volt; range=(0,1);]
  double STempHeight;

 private:

 //! Internal constants for spike template calculations.
 int STempIdxMax;

 static const double STEMP[];

 static const int NSTEMP;

 int STempIdx;

};

#endif
